% The basename of the model. The excel file with settings should have the exact
% same name (+xls) 
basename='Moab191NW';

% Map for analysis:
[MAP, cmap] = imread('map_geocolours_ed.gif');
MAP = double( MAP );

% Map for show:
baseimagefile = 'map_geocolours_ed.gif';

% Specify if an alteration map is available for plotting, uncomment the
% altimagefile and change the name if it is.
altavailable = true;
altimagefile = 'map_alt.gif';

% Size of pixels in the image and subsequently grid cells in the model.
cellsize = 0.005; % 0.5cm grid cells

% Flow direction:
FlowDirection = 'horizontal'

% Vertical inflow range (cells in the bottom row which are open for fluid
% flow, for along fault flow models. This is used to simulate fluids
% flowing up through the fault core rather than bypassing it through the
% damage zone.
% inflowrange = 1:996;

% TODO Something
% Permeability assignment
% Use:
% image(MAP), colormap(cmap), axis image
% To display the model map. Use the data cursor in the image window to find
% the values of different mapped units. 
% unique( MAP(:) ) gives all the image values in use.
% The legend items and permeabilities should be in the same order as the
% imagevalues.


imagevaluesused = [ 0, 1, 2, 3, 4, 5, 6, 7, 8 ];

namesandperms = {'Coarse altered sst', 3.3, 'Pebbly sst',100, 'Medium sst', 300, 'Fine sst',58,  'Very fine sst', 5,  'Cemented sst', 1e-4, 'Siltstone', 1e-5, 'Silty gouge', 5e-6, 'Slip surface', 25000};


legenditems = namesandperms(1:2:end-1);
permeabilities = cell2mat( namesandperms(2:2:end) );


makenewlegend = true;
% legendtouse = 'legendwithslipsurfaces.svg';

% colour of the streamlines; k for black, w for white, see matlab help plot
% for more examples
streamlinestyle = '-k';

% Size of the scale bar to plot on top of the model
scale_bar_length = 1; %10 cm scale bar
barlabel = '1 m';
